function [cluster_center par] = extract_parameters(y,cluster,exemplars,par);


num=length(y);


for it=1:20

    L=0;
    for i=1:num
        L=L+length(y{i});
        Li(i)=length(y{i});
        associated{i}=[];
        centers{i}=[];
    end;

    %Determine cluster centers
    for k=1:length(exemplars)
        xvec=[];
        sigmavec=[];
        [a b]=size(cluster{k});
        for cc=1:a
            i = cluster{k}(cc,1);
            sigmavec=[sigmavec power(par.sigma(i),-2)];
            event=y{cluster{k}(cc,1)}(cluster{k}(cc,2));
            xvec=[xvec power(par.sigma(i),-2)*(event-par.delta(i))];
        end;
        cluster_center(k)=sum(xvec/sum(sigmavec));
    end;

    %Update SES parameters
    for k=1:length(exemplars)
        [a b]=size(cluster{k});
        for cc=1:a
            i = cluster{k}(cc,1);
            j = cluster{k}(cc,2);
            centers{i} = [centers{i} cluster_center(k)];
            associated{i}=[associated{i} j];
        end;
    end;

    sigmaAV=0;
    assoc=0;
    for i=1:num
        par.delta(i)=mean(y{i}(associated{i})-centers{i});
        par.sigma(i)=var(y{i}(associated{i})-centers{i}-par.delta(i));
        sigmaAV=sigmaAV+sqrt(par.sigma(i))*sum(associated{i}>0);
        assoc=assoc+sum(associated{i}>0);
    end;
    sigmaAV=(sigmaAV+par.n0*par.sigma0)/(assoc+par.n0);

    diff_vec=[];
    for i=1:num
        diff_vec=[diff_vec y{i}(associated{i})-centers{i}-par.delta(i)];
    end;
    par.diff=diff_vec;




    for i=1:num
        par.sigma(i)=sigmaAV;
    end;


end;
