close all
clear all

pback=0;
num_sims=10;

param.verbose=0;
param.its=5;

%generate data
pd_vec=[0:0.1:0.4];
stdevt_vec=[10 30 50];
stdevf_vec=[1];
num=5;
param.beta=0.01;
param.delay=0;
l0=20;

param.beta2=1e-20;
param.back=1;
param.n0=0;
param.sigma0t=100;
param.sigma0f=1;
param.fmax=l0;


for pd=pd_vec
    pd
    for stdevtcount=1:length(stdevt_vec)
        param.stdevt=stdevt_vec(stdevtcount);
        param.stdevt

        for stdevfcount=1:length(stdevf_vec)
            param.stdevf=stdevf_vec(stdevfcount);
            param.stdevf
            len=floor(l0/(1-pd));
            numback=ceil(len*pback*num);

            clear results
            for sim=1:num_sims
                sim
                clear x
                x(1,:)=1:len;
                x(1,:)=100*x(1,:);
                x(2,:)=rand(1,len)*param.fmax;
                switch param.stdevt
                    case {10,30}
                        param.max_distt=500;
                    case {50}
                        param.max_distt=500;
                end;
                switch param.stdevf
                    case {1,2.5}
                        param.max_distf=100;
                    case {5}
                        param.max_distf=100;
                end
                for i=1:num
                    y{i,1}=[];
                    y{i,2}=[];
                    z{i,1}=x(1,:)+param.stdevt*randn(1,floor(len));
                    z{i,2}=max(x(2,:)+param.stdevf*randn(1,floor(len)),0);
                    for j=1:length(z{i})
                        if rand>pd
                            y{i,1}=[y{i,1} z{i,1}(j)];
                            y{i,2}=[y{i,2} z{i,2}(j)];
                        end;
                    end;
                end;

                for k=1:numback
                    i=ceil(rand*num);
                    y{i,1}=[y{i,1} rand*max(x(1,:))];
                    y{i,2}=[y{i,2} rand*param.fmax];
                end;



                %cluster
                param.init_deltat_vec=zeros(2,num);
                param.init_sigmat_vec=[20 30];
                param.deltaf=zeros(1,num);
                param.sigmaf=3*ones(1,num);
                
                [param cluster centers exemplars background] = SES2d_algorithm(y,param);
                results{sim}.param=param;
                results{sim}.cluster=cluster;
                results{sim}.centers=centers;
                results{sim}.exemplars=exemplars;
                results{sim}.background=background;
                
                
                %print_figure_2d(y,cluster,centers,exemplars,background,param);
                %pause

            end;

            %save(['2dNvariate_pd_' num2str(pd) '_delay_' num2str(param.delay) '_stdevt_' num2str(param.stdevt) '_stdevf_' num2str(param.stdevf) '_len_' num2str(l0) '_beta_' num2str(param.beta) '.mat'],'results');
        end;
    end;
end;