close all
clear all


%data files
param.dist=4;
param.band='all';
param.tot_electrode_number=5;


%set parameters
param.beta=0.01;
param.delay=0;

param.beta2=1e-20;
param.back=1;
param.n0=1000;
param.max_distt=100;
param.max_distf=40;

param.verbose=1;
param.its=5;


for beta=[0.01]
    param.beta=beta;
    beta
    for T =[0.22:0.01:0.22]
        param.T=T;
        T
        for sigma0t=[1:0.5:2.5]
            param.sigma0t=sigma0t;
            sigma0t
            for sigma0f=[0.05 0.1 0.15]
                param.sigma0f=sigma0f;
                sigma0f

                %MCI
                param.patient_type='MCI';
                param.tot_patient_number=22;

                load(['results/Bump_Musha_' param.patient_type '_beta_' num2str(param.beta) '_sigmat_' num2str(param.sigma0t) '_sigmaf_' num2str(param.sigma0f) '_n0_' num2str(param.n0) '_dist_' num2str(param.dist) '_T_' num2str(param.T) '_zones_' num2str(param.tot_electrode_number)  '.mat'],'results');
                for pat=1:param.tot_patient_number;
                    sigmaf_MCI(pat)=results{pat}.param.sigmaf(1);
                    sigmat_MCI(pat)=results{pat}.param.sigmat(1);
                    rho_MCI(pat)=results{pat}.rho;
                end;

                %CTR
                param.patient_type='CTR';
                param.tot_patient_number=38;

                load(['results/Bump_Musha_' param.patient_type '_beta_' num2str(param.beta) '_sigmat_' num2str(param.sigma0t) '_sigmaf_' num2str(param.sigma0f) '_n0_' num2str(param.n0) '_dist_' num2str(param.dist) '_T_' num2str(param.T) '_zones_' num2str(param.tot_electrode_number)  '.mat'],'results');
                for pat=1:param.tot_patient_number;
                    sigmaf_CTR(pat)=results{pat}.param.sigmaf(1);
                    sigmat_CTR(pat)=results{pat}.param.sigmat(1);
                    rho_CTR(pat)=results{pat}.rho;
                end;
                sigmat_MCI
                sigmaf_MCI

                ranksum(sigmat_MCI, sigmat_CTR)
                ranksum(sigmaf_MCI, sigmaf_CTR)
                ranksum(rho_MCI, rho_CTR)
            end;
        end;
    end;
end;