close all
clear all


num_sims=10;

param.verbose=1;
param.its=5;

%generate data
pd_vec=[0:0.1:0.4];
stdev_vec=[10 30 50];
param.stdevf=5;

num=5;
beta=0.01;
param.delay=0;
l0=40;

pd_count=0;
for pd=pd_vec
    pd_count=pd_count+1;
    for stdevcount=1:length(stdev_vec)
        param.stdevt=stdev_vec(stdevcount);
        load(['2dNvariate_pd_' num2str(pd) '_delay_' num2str(param.delay) '_stdevt_' num2str(param.stdevt) '_stdevf_' num2str(param.stdevf) '_len_' num2str(l0) '_beta_' num2str(beta) '.mat'],'results');
        for i=1:10
            num_vec=[];
            sigma_vec(i)=results{i}.param.sigmat(1);
            cluster_local=results{i}.cluster;
            for ii=1:length(cluster_local)
                num_vec=[num_vec length(cluster_local{ii})];
            end;
            back(i)=length(results{i}.background);
            rho_vec(i)=mean(1-num_vec/5);
        end;
        sigma_mean(pd_count,stdevcount)=mean(sigma_vec);
        sigma_std(pd_count,stdevcount)=std(sigma_vec);
        rho_mean(pd_count,stdevcount)=mean(rho_vec);
        rho_std(pd_count,stdevcount)=std(rho_vec);
        back_mean(pd_count,stdevcount)=mean(back);

    end;
end;

%print
%print_figure(y,cluster,centers,exemplars,param);

figure(1);
h=plot(pd_vec,sigma_mean);
grid on;

xlabel('x');
ylabel('y');

grid on;
%axis([0 0.4 0 1]);

set(h,'LineWidth',3);
set(gca,'FontSize',25);
legend('\sigma_t = 10','\sigma_t = 30','\sigma_t = 50',-1);
axis([0 0.4 0 50]);
print('-dpsc2',['SES2d_surrogate_ps_len_' num2str(l0) '.eps']);




figure(2)

h=plot(pd_vec,rho_mean);
grid on;

xlabel('x');
ylabel('y');

grid on;
%axis([0 0.4 0 1]);
set(gca,'FontSize',25);
legend('\sigma_t = 10','\sigma_t = 30','\sigma_t = 50',-1);
set(h,'LineWidth',3);
axis([0 0.4 0 0.4]);
print('-dpsc2',['SES2d_surrogate_ps_len_' num2str(l0) '.eps']);



figure(3);
h=plot(pd_vec,sigma_std);
grid on;

xlabel('x');
ylabel('y');

grid on;
%axis([0 0.4 0 1]);

set(h,'LineWidth',3);
set(gca,'FontSize',25);
legend('\sigma_t = 10','\sigma_t = 30','\sigma_t = 50',-1);
axis([0 0.4 0 50]);
print('-dpsc2',['SES2d_surrogate_ps_len_' num2str(l0) '.eps']);




figure(4)

h=plot(pd_vec,rho_std);
grid on;

xlabel('x');
ylabel('y');

grid on;
%axis([0 0.4 0 1]);
set(gca,'FontSize',25);
legend('\sigma_t = 10','\sigma_t = 30','\sigma_t = 50',-1);
set(h,'LineWidth',3);
axis([0 0.4 0 0.4]);
print('-dpsc2',['SES2d_surrogate_ps_len_' num2str(l0) '.eps']);



figure(5)

h=plot(pd_vec,back_mean);
grid on;

xlabel('x');
ylabel('y');

grid on;
%axis([0 0.4 0 1]);
set(gca,'FontSize',25);
legend('\sigma_t = 10','\sigma_t = 30','\sigma_t = 50',-1);
set(h,'LineWidth',3);
axis([0 0.4 0 0.4]);
%print('-dpsc2',['SES_surrogate_ps_len_' num2str(l0) '.eps']);
