function [] = bump_SES(param)

filename=strcat('Musha_3_7/bump_model.mat');

%extract data
load(filename);

EEG=modele.mld;


for patient_number=1:param.tot_patient_number
    if (param.verbose>0)
        patient_number
    end;

    %cluster
    param.init_deltat_vec=zeros(1,param.tot_electrode_number);
    param.init_sigmat_vec=param.sigma0t;
    param.deltaf=zeros(1,param.tot_electrode_number);
    param.sigmaf=param.sigma0f*ones(1,param.tot_electrode_number);
    %param.init_delta_vec(2,:)=10*ones(1,tot_electrode_number);

    for electrode=1:param.tot_electrode_number
        y{electrode,1}=ceil(double(EEG{patient_number}.elec{electrode}(:,5)))';
        y{electrode,2}=double(EEG{patient_number}.elec{electrode}(:,4))';
        y{electrode,3}=double(EEG{patient_number}.elec{electrode}(:,3))'; %width
        y{electrode,4}=double(EEG{patient_number}.elec{electrode}(:,2))'; %heigth
    end;

    [param cluster centers exemplars background] = SES2d_algorithm(y,param);

    vec=[];
    for i=1:length(cluster)
        vec=[vec length(cluster{i})];
    end;
    rho=1-mean(vec)/param.tot_electrode_number;


    results{patient_number}.param=param;
    results{patient_number}.cluster=cluster;
    results{patient_number}.centers=centers;
    results{patient_number}.exemplars=exemplars;
    results{patient_number}.background=background;
    results{patient_number}.rho=rho;


end;

