function [cluster_center par] = extract_parameters_2d(y,cluster,exemplars,par);

[a b] = size(y);
num=a;

for it=1:20

    L=0;
    for i=1:num
        L=L+length(y{i});
        Li(i)=length(y{i});
        associated{i}=[];
        centers{i,1}=[];
        centers{i,2}=[];
    end;


    %Determine cluster centers
    for k=1:length(exemplars)
        xvec=[];
        yvec=[];
        sigmatvec=[];
        sigmafvec=[];
        [a b]=size(cluster{k});
        for cc=1:a
            i = cluster{k}(cc,1);
            sigmatvec=[sigmatvec power(par.sigmat(i),-2)];
            sigmafvec=[sigmafvec power(par.sigmaf(i),-2)];
            eventt=y{cluster{k}(cc,1),1}(cluster{k}(cc,2));
            eventf=y{cluster{k}(cc,1),2}(cluster{k}(cc,2));
            xvec=[xvec power(par.sigmat(i),-2)*(eventt-par.deltat(i))];
            yvec=[yvec power(par.sigmaf(i),-2)*(eventf-par.deltaf(i))];
        end;
        cluster_center(k,1)=sum(xvec/sum(sigmatvec));
        cluster_center(k,2)=sum(yvec/sum(sigmafvec));
    end;

    %Update SES parameters
    for k=1:length(exemplars)
        [a b]=size(cluster{k});
        for cc=1:a
            i = cluster{k}(cc,1);
            j = cluster{k}(cc,2);
            centers{i,1} = [centers{i,1} cluster_center(k,1)];
            centers{i,2} = [centers{i,2} cluster_center(k,2)];
            associated{i}=[associated{i} j];
        end;
    end;

    sigmaAVt=0;
    sigmaAVf=0;
    assoc=0;
    for i=1:num
        par.deltat(i)=mean((y{i,1}(associated{i})-centers{i,1})./y{i,3}(associated{i}));
        par.sigmat(i)=var((y{i,1}(associated{i})-centers{i,1}-par.deltat(i))./y{i,3}(associated{i}));
        par.deltaf(i)=mean((y{i,2}(associated{i})-centers{i,2})./y{i,4}(associated{i}));
        par.sigmaf(i)=var((y{i,2}(associated{i})-centers{i,2}-par.deltaf(i))./y{i,4}(associated{i}));

        sigmaAVt=sigmaAVt+sqrt(par.sigmat(i))*sum(associated{i}>0);
        sigmaAVf=sigmaAVf+sqrt(par.sigmaf(i))*sum(associated{i}>0);
        assoc=assoc+sum(associated{i}>0);
    end;
    sigmaAVt=(sigmaAVt+par.n0*par.sigma0t)/(assoc+par.n0);
    sigmaAVf=(sigmaAVf+par.n0*par.sigma0f)/(assoc+par.n0);


    diff_vec=[];
    for i=1:num
        diff_vec=[diff_vec y{i,1}(associated{i})-centers{i,1}-par.deltat(i)];
    end;
    par.difft=diff_vec;


    diff_vec=[];
    for i=1:num
        diff_vec=[diff_vec y{i,2}(associated{i})-centers{i,2}-par.deltaf(i)];
    end;
    par.difff=diff_vec;

    for i=1:num
        par.sigmat(i)=sigmaAVt;
    end;

    for i=1:num
        par.sigmaf(i)=sigmaAVf;
    end;
end;
