clear all
close all

beta_vec=[1e-5 5e-5 1e-4 5e-4 1e-3 5e-3 1e-2 5e-2];
spur_prob=[0.01];

show_result=1;


maxnum=50;  %Can be at most 50, since we have 50 spike trains
type=1;
len=1e4;

for batch=1:4
    batch
    for beta=beta_vec
        clear param cluster centers exemplars background
        for neuron1=1:maxnum;
            if (type==2)
                load('ML_typeII_50_test.mat');
            elseif(type==1)
                load('ML_typeI_50_test.mat');
            end;

            y{neuron1}=ML_events{neuron1}((ML_events{neuron1}<batch*len));
            y{neuron1}=y{neuron1}((y{neuron1}>(batch-1)*len));
            y{neuron1}=y{neuron1}/10;
        end;


        %cluster
        param.init_sigma_vec=[5];
        param.init_delta_vec=zeros(1,maxnum);
        param.verbose=0;
        param.its=50;
        param.max_dist=50;
        param.beta=beta;
        param.beta2=1e-10;
        param.n0=0;
        param.sigma0=100;

        [param cluster centers exemplars background] = SES_algorithm(y,param);


        num_vec=[];
        for ii=1:length(cluster)
            num_vec=[num_vec length(cluster{ii})];
        end;

        rho_vec=mean(1-num_vec/maxnum);



        if (show_result)

            print_figure(y,cluster,centers,exemplars,background,param);
            xlabel('x');
            ylabel('y');
            set(gca,'FontSize',15);
            pause;
        end;

        %save(['Morris_Lecar_type_' num2str(type) '_beta_' num2str(param.beta) '_' num2str(batch) '.mat']);

    end;
end;