close all
clear all

backON=0;
pback=0;
num_sims=10;

param.verbose=1;
param.its=5;

%generate data
pd_vec=[0:0.1:0.4];
stdev_vec=[10 30 50];
num=5;
param.beta=0.04;
param.delay=0;
l0=20;

param.beta2=1e-20;
param.back=1;
param.n0=0;
param.sigma0=100;



for pd=pd_vec
    pd
    for stdevcount=1:length(stdev_vec)
        param.stdev=stdev_vec(stdevcount);
        param.stdev
        len=l0/(1-pd);
        numback=ceil(len*pback*num);
        clear results
        for sim=1:num_sims
            sim
            x=1:len;
            x=100*x;
            param.max_dist=300;
            for i=1:num
                y{i}=[];
                z{i}=x+param.stdev*randn(1,floor(len));
                for j=1:length(z{i})
                    if rand>pd
                        y{i}=[y{i} z{i}(j)];
                    end;
                end;
            end;

            for k=1:numback
                i=ceil(rand*num);
                y{i}=[y{i} rand*max(x)];
                y{i}=sort(y{i});
            end;

            %cluster
            param.init_sigma_vec=[20 30];
            param.init_delta_vec=zeros(2,num);

            [param cluster centers exemplars background] = SES_algorithm(y,param);
            results{sim}.param=param;
            results{sim}.cluster=cluster;
            results{sim}.centers=centers;
            results{sim}.exemplars=exemplars;
            results{sim}.background=background;

            %print_figure(y,cluster,centers,exemplars,background,param);            
            %pause
            %clf;
        end;

        %save(['1d_Nvariate_pd_' num2str(pd) '_delay_' num2str(param.delay) '_stdev_' num2str(param.stdev) '_len_' num2str(l0) '_beta_' num2str(param.beta) '.mat'],'results');
    end;
end;
