function [delta,sigma,rho,coincident_1,coincident_2,no_of_its]= pairwise_SES_1d(train1,train2,beta,sigma_init_vec)
%
%function [delta,sigma,rho,coincident_1,coincident_2,no_of_its]=pairwise_SES_1d(train1,train2,beta,sigma_init_vec)
%
%
%This script quantifies the synchrony between two one-dimensional point processes (spike trains). 
%More precisely, it determines "Stochastic Event Synchrony": time delay (delta), 
%stdev of the jitter (sigma), and the fraction of non-coincident events (rho).
%
%*coincident_1 and coincident_1:
%The coincident events in both point processes
%
%*no_of_its:
%The number of iterations the SES algorithm required to converge
%
%* train1 and train2:
%The two given one-dimensional point processes
%
%* sigma_init_vec: 
%Vector of initial estimates for the jitter standard deviation; 
%we advise to choose a few values (3 to 5) within a reasonable range, 
%e.g., from one tenth of the average interspike time to the interspike time.
%
%* beta:
%We suggest to set beta = 0.01. We have selected this value through
%extensive statistical analysis of SES on surrogate and real data.
%
%
%For suggestions, questions, bug reports, email:jdauwels@mit.edu  (Justin Dauwels)


%initial estimate
delay_init=0;

tot_log_p=zeros(1,length(sigma_init_vec));
tot_delay=zeros(1,length(sigma_init_vec));
tot_sigma=zeros(1,length(sigma_init_vec));
tot_rho_spur=zeros(1,length(sigma_init_vec));
tot_ICM_it=zeros(1,length(sigma_init_vec));


%constants
its  = 50;        %number of iterations
show_plots=0;

sigma_choice=0;

for sigma_init=sigma_init_vec

    sigma_choice=sigma_choice+1;
    rho_spur=1;

    %Constants
    len1=length(train1);                                            %number of spikes in train1
    len2=length(train2);                                            %number of spikes in train2

    if (len1&&len2)
        maxlen=max(train1(len1),train2(len2));                      %time of the latest event
        minlen=min(train1(1),train2(1));
        maxlen=maxlen-minlen+1;


        %Run ICM

        %Initialize some vectors
        delay_vec=[delay_init];
        sigma_vec=[sigma_init];
        sigma=sigma_init;
        delay=delay_init;
        delay_old=0;
        sigma_old=0;

        for ICM_it=1:its

            %--------------------
            %Dynamic programming
            %--------------------

            %Generate table of log-probabilities
            logp=-inf*ones(len1+1,len2+1);
            for i=2:len1
                logp(i,1)=(i-1)*log(spur_prob);
            end;
            for i=2:len2
                logp(1,i)=(i-1)*log(spur_prob);
            end;
            logp(1,1)=0;
            path=zeros(len1+1,len2+1);
            for count1=2:len1+1
                for count2=2:len2+1
                    distance=1/2*log(2*pi*sigma*sigma)+power((train2(count2-1)-train1(count1-1)-delay)/(sqrt(2)*sigma),2);
                    possible_logp=[logp(count1-1,count2)+log(spur_prob) logp(count1,count2-1)+log(spur_prob) logp(count1-1,count2-1)-distance];
                    [logp(count1,count2) path(count1,count2)]=max(possible_logp);
                end;
            end;
            tot_log_p(sigma_choice)=logp(count1,count2);

            %Backward step
            count1=len1+1;
            count2=len2+1;
            nonspur_1=[];
            nonspur_2=[];
            nonspur_index_1=[];
            nonspur_index_2=[];
            spur_1=[];
            spur_2=[];

            while ((count1>1)&&(count2>1))
                switch path(count1,count2)
                    case 1
                        count1=count1-1;
                    case 2
                        count2=count2-1;
                    case 3
                        count1=count1-1;
                        count2=count2-1;
                        nonspur_1=[train1(count1) nonspur_1];
                        nonspur_2=[train2(count2)  nonspur_2];
                        nonspur_index_1=[nonspur_index_1 count1];
                        nonspur_index_2=[nonspur_index_2 count2];


                end;
            end;

            spur_index_1=1:len1;
            spur_index_2=1:len2;
            spur_index_1(nonspur_index_1)=[];
            spur_index_2(nonspur_index_2)=[];
            spur_1=train1(spur_index_1);
            spur_2=train2(spur_index_2);

            %------------------------------
            %Estimation of delay and jitter
            %-------------------------------
            %Compute timing offset and jitter varianceiance
            nonspur_len=length(nonspur_1);
            if(nonspur_len) %Normal case, where not all events are spurious
                delay=0;
                variance=0;
                for nonspur_count=1:nonspur_len
                    delay=delay+nonspur_2(nonspur_count)-nonspur_1(nonspur_count);
                    variance=variance+power(nonspur_2(nonspur_count)-nonspur_1(nonspur_count),2);
                end;
                %timing offset
                delay=delay/nonspur_len;
                delay_vec=[delay_vec delay];

                %jitter varianceiance
                variance=variance/nonspur_len;
                sigma=sqrt(variance-delay*delay);
                sigma_vec=[sigma_vec sigma];

                %Stop iterating if the algorithm has converged
                if(((abs(sigma_old-sigma)<0.000001)&&(abs(delay_old-delay)<0.000001))||not(sigma))
                    break;
                end;
                delay_old=delay;
                sigma_old=sigma;


            else %Pathological case where all events are spurious...
                delay=NaN;
                sigma=NaN;
                delay_old=delay;
                sigma_old=sigma;
                break;
            end;
            rho_spur=1-2*nonspur_len/(len1+len2);


        end;
        tot_delay(sigma_choice)     = delay;
        tot_sigma(sigma_choice)     = sigma;
        tot_rho_spur(sigma_choice)  = rho_spur;
        tot_ICM_it(sigma_choice)    = ICM_it;
        tot_nonspur_1{sigma_choice} = nonspur_1;
        tot_nonspur_2{sigma_choice} = nonspur_2;



    else
        delay=NaN;
        sigma=NaN;
        rho_spur=1;
    end;

end;
[vall idd]=max(tot_log_p);
delta=tot_delay(idd);
sigma=tot_sigma(idd);
rho=tot_rho_spur(idd);
no_of_its=tot_ICM_it(idd);
coincident_1=tot_nonspur_1{idd};
coincident_2=tot_nonspur_2{idd};