clear all
close all

sigma_init_vec=[10 30 50 100];
spur_prob=[0.01];


maxnum=10;  %Can be at most 50, since we have 50 spike trains

type=2;
for neuron1=1:maxnum;
    neuron1
    for neuron2=neuron1+1:maxnum;

        if (type==2)
            load('ML_typeII_50_test.mat');
        elseif(type==1)
            load('ML_typeI_50_test.mat');
        end;

        train1=ML_events{neuron1};
        train2=ML_events{neuron2};

        [delta,sigma,rho,coincident_1,coincident_2,no_of_its]=pairwise_SES_1d(train1,train2,spur_prob,sigma_init_vec);
        delta_matrix(neuron1,neuron2)=delta;
        sigma_matrix(neuron1,neuron2)=sigma;
        rho_matrix(neuron1,neuron2)=rho;

    end;
end;